/**@file AboutDialog.cpp: Form with about dialog*/

// For compilers that supports precompilation , includes "wx/wx.h"
#include "wx/wxprec.h"
#ifndef WX_PRECOMP
 #include "wx/wx.h"
#endif

#include "AboutDialog.h"
#include "hardware/OsSupp.h"

#define SPLASH_SCREEN_DURATION 3000   ///< Time in ms how a splash screen would be shown


const TCHAR LicText[] = N_("This program could be redistributed\nunder conditions of GPL2.0"
                        "\nLibrary wxWidgets have its own licence.");
const char TextURL[] = "http://ftsoft.com.cz/CamView/";
const char TextAltURL[] = "http://ftsoft.wz.cz/CamView/";


DEFINE_EVENT_TYPE(wxEVT_STATIC_TEXT_CLICKED)


BEGIN_EVENT_TABLE(AboutFrame, wxFrame)
    EVT_PAINT(                AboutFrame::OnPaint)
    EVT_TIMER(ID_TIMER,       AboutFrame::OnTimer)
    EVT_LEFT_DOWN(            AboutFrame::OnMouse)
END_EVENT_TABLE()

BEGIN_EVENT_TABLE(AboutDialog, wxDialog)
    EVT_PAINT(                AboutDialog::OnPaint)
    EVT_BUTTON(ID_BTN_OK,     AboutDialog::OnOk)
    EVT_COMMAND(ID_URL_TEXT, wxEVT_STATIC_TEXT_CLICKED, AboutDialog::OnClickURL)
    EVT_COMMAND(ID_ALT_URL_TEXT, wxEVT_STATIC_TEXT_CLICKED, AboutDialog::OnClickAltURL)
END_EVENT_TABLE()


BEGIN_EVENT_TABLE(mouseStaticText, wxStaticText)
    EVT_SYS_COLOUR_CHANGED(wxWindowMSW::OnSysColourChanged)
    EVT_ERASE_BACKGROUND(wxWindowMSW::OnEraseBackground)
    EVT_LEFT_DOWN(            mouseStaticText::OnMouse) 
#ifdef __WXWINCE__
    EVT_INIT_DIALOG(wxWindowMSW::OnInitDialog)
#endif
END_EVENT_TABLE()


/// Mouse click event needs to be propagated.
void mouseStaticText::OnMouse(wxMouseEvent& event)
{
    /* Emit notification about camera change. */
  wxCommandEvent NewEvent(wxEVT_STATIC_TEXT_CLICKED,GetId());
  NewEvent.SetEventObject(this);  
  //event.SetText( wxT("Camera") );  // Give it some contents (I hope that this is not necessary)
  GetEventHandler()->ProcessEvent(NewEvent);
}


//////////////////////////////////////////////////////////


AboutFrame::AboutFrame(wxFrame *parent, const char *ImageName, const char *CaptionName):
        wxFrame(parent, -1, CaptionName==NULL?"About":CaptionName, wxDefaultPosition, wxSize(293,376),
        wxSIMPLE_BORDER|wxFRAME_NO_TASKBAR|wxSTAY_ON_TOP), // | wxRESIZE_BORDER),       
        mCloseTimer(this, ID_TIMER)
{
   BuildLayout(parent, this, ImageName);
   CentreOnScreen();
   mCloseTimer.Start(SPLASH_SCREEN_DURATION);
}

AboutDialog::AboutDialog(wxFrame *parent, const char *ImageName, const char *CaptionName):
        wxDialog(parent, -1, CaptionName==NULL?"About":CaptionName, wxDefaultPosition,
        wxSize(293+6,376+26), wxDEFAULT_DIALOG_STYLE) // | wxRESIZE_BORDER),       
{
   BuildLayout(parent, (wxFrame *)this, ImageName);
}


AboutBase::~AboutBase()
{
  if(m_bmpBkg) {delete m_bmpBkg;m_bmpBkg=NULL;}
}


void AboutBase::BuildLayout(wxFrame *parent, wxFrame *ThisW, const char *ImageName)
{
  wxSizer *sizerDown = new wxBoxSizer(wxVERTICAL);

  m_pLicText = new wxStaticText(ThisW, -1, _(LicText), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTER|wxTRANSPARENT_WINDOW);
  sizerDown->Add(m_pLicText, 0, wxALIGN_BOTTOM|wxGROW);

  m_pURL_Text = new mouseStaticText(ThisW, ID_URL_TEXT, TextURL, wxDefaultPosition, wxDefaultSize, wxALIGN_CENTER|wxTRANSPARENT_WINDOW);
  m_pAltURL_Text = new mouseStaticText(ThisW, ID_ALT_URL_TEXT, TextAltURL, wxDefaultPosition, wxDefaultSize, wxALIGN_CENTER|wxTRANSPARENT_WINDOW);

  wxBoxSizer *sizerBtns = new wxBoxSizer(wxHORIZONTAL);
   
  sizerBtns->Add(10, 0, wxALIGN_RIGHT); // spacer
  m_pOkButton = new wxButton(ThisW, ID_BTN_OK, "OK"); //, wxPoint(-1, -1));
  sizerBtns->Add(m_pOkButton,0,wxALIGN_RIGHT);

  sizerBtns->Add(20,20,wxALIGN_LEFT); // spacer

  m_pInfoText = new wxStaticText(ThisW, -1, "", wxDefaultPosition, wxDefaultSize, wxALIGN_CENTER|wxTRANSPARENT_WINDOW);
  sizerBtns->Add(m_pInfoText, wxALIGN_RIGHT|wxGROW);
  sizerBtns->Add(10, 0, wxALIGN_RIGHT); // spacer
   
  sizerDown->AddSpacer(180);
  sizerDown->Add(m_pURL_Text, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_BOTTOM);
  sizerDown->AddSpacer(5);
  sizerDown->Add(m_pAltURL_Text, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_BOTTOM);
  sizerDown->Add(0,5,wxALIGN_BOTTOM);
  sizerDown->Add(sizerBtns, 0, wxALIGN_BOTTOM);
  sizerDown->Add(0,7);

  ThisW->SetSizer(sizerDown);

  if(ImageName)
  {
    m_bmpBkg=new wxBitmap;
    if(!WxLoadBitmap(m_bmpBkg,ImageName))
       {delete m_bmpBkg; m_bmpBkg=NULL;}
  }
  else m_bmpBkg=NULL;

  if(parent)
    ThisW->SetIcon(parent->GetIcon());  //prefer same icons for all opened frames   
   
  wxColor Bg(255,255,255);
  m_pInfoText->SetBackgroundColour(Bg);
  wxColor Fg(0,0,0);
  m_pInfoText->SetForegroundColour(Fg);   

  ThisW->SetAutoLayout(true);
  ThisW->Layout();
}


/** Paint a bitmap background during paint event. */
void AboutBase::OnPaint(wxFrame *Fram)
{   
int width;
int height;
   
  wxPaintDC dc(Fram);
   
  if(m_bmpBkg)
    {        
    Fram->GetClientSize(&width, &height);	//paint a bitmap on a canvas    
    dc.DrawBitmap(*m_bmpBkg, 0, 0);
    }
  else 
    dc.Clear();
}


void AboutFrame::SetText(const wxString& text)
{
  m_pInfoText->SetLabel(text);    
    // Call layout, because the static text could be resized.    
  Layout();
}


/** Close a frame on ny mouse click. */
void AboutFrame::OnMouse(wxMouseEvent & event)
{
  if (event.LeftDown())
    Close(true);
}


//////////////////////////////////////////////////////////////////


void AboutDialog::SetText(const wxString& text)
{
  m_pInfoText->SetLabel(text);    
    // Call layout, because the static text could be resized.    
  Layout();
}


void AboutFrame::OnTimer(wxTimerEvent & WXUNUSED(event))
{
  Close(true);
}


void AboutDialog::OnOk(wxCommandEvent & WXUNUSED(event))
{
  Close(true);
}


void AboutDialog::OnClickURL(wxCommandEvent& event)
{
  ShellExecute(NULL, "open", TextURL, NULL, NULL, SW_SHOWNORMAL);
}


void AboutDialog::OnClickAltURL(wxCommandEvent& event)
{
  ShellExecute(NULL, "open", TextAltURL, NULL, NULL, SW_SHOWNORMAL);
}

