/**@file PntWxTools.cpp: Special functions for transfering data from points to wx - prototypes. */
#include <wx/wxprec.h>
#ifndef WX_PRECOMP
 #include <wx/wx.h>
#endif

#include "points.h"
#include "wxTools.h"
#include "hardware/OsSupp.h"

#include "PntwxTools.h"


void PropagateEditboxChange(wxTextCtrl *TxtVal, Point *PntVal)
{
double Val;

  if(TxtVal==NULL || PntVal==NULL) return;
  
  Val=CheckDoubleTxt(TxtVal);
  PntVal->SetDouble(Val);
  if(!IsNaN(&Val))
    {    
    TxtVal->SetForegroundColour(wxColour("RED"));
    }
  else
    {
    TxtVal->SetForegroundColour(wxColour("BLACK"));
    }
}


void CheckEditboxAndPoint(wxTextCtrl *TxtVal, Point *PntVal)
{
double Val;
wxString str;

  if(TxtVal==NULL || PntVal==NULL) return;
    
  Val=CheckDoubleTxt(TxtVal);
  if(!IsNaN(&Val))
    {
    if(Val!=PntVal->GetDouble())		//TargetY has been changed - update edit box
      {
      str.Printf( wxT("%.2f"), PntVal->GetDouble());
      TxtVal->SetValue(str);     
      }
    }
  else   //editbox contains invalid value
    {
    Val=PntVal->GetDouble();
    if(!IsNaN(&Val))
      {
      str.Printf( wxT("%.2f"), PntVal->GetDouble());
      TxtVal->SetValue(str);     
      }
    }
}


void UpdateValueFromPnt(wxTextCtrl *TxtVal, Point *PntVal)
{
  if(TxtVal==NULL) return;

  if(PntVal)
    {
    double Val=PntVal->GetDouble();
    if(!IsNaN(&Val))
       {
       wxString str;
       str.Printf(wxT("%.2f"),Val);
//       TxtVal->SetValue(str); 
//       TxtVal->SetBackgroundColour(wxColour("LIGHT GREY"));
       } 
    else
       {
//       TxtVal->SetValue(_T("???"));
//       TxtVal->SetBackgroundColour(wxColour("RED"));
       }
    }
  else
    {
//    TxtVal->SetValue(_T("N/A"));
//    TxtVal->SetBackgroundColour(wxColour("RED"));
    }
}