; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

#define MyAppName "CamView64"
#define MyAppVersion "2.3"
#define MyAppPublisher "F&T Soft"
#define MyAppURL "http://ftsoft.com.cz/CamView/"

[Setup]
; NOTE: The value of AppId uniquely identifies this application.
; Do not use the same AppId value in installers for other applications.
; (To generate a new GUID, click Tools | Generate GUID inside the IDE.)

AppId={{626A4A52-B64A-4e80-B501-34034B517E2A}
AppName={#MyAppName}
AppVersion={#MyAppVersion}
;AppVerName={#MyAppName} {#MyAppVersion}
AppPublisher={#MyAppPublisher}
AppPublisherURL={#MyAppURL}
AppSupportURL={#MyAppURL}
AppUpdatesURL={#MyAppURL}
DefaultDirName={pf64}\{#MyAppName}
UsePreviousAppDir=yes
DefaultGroupName={#MyAppName}
OutputDir=output_file
OutputBaseFilename=CamView64_Installer-{#MyAppVersion}
Compression=lzma
SolidCompression=yes
Uninstallable=yes
AppendDefaultDirName=yes
AppMutex=CamView64_Mutex,Global\CamView64_Mutex
;SetupIconFile 

[Languages]
Name: "english"; MessagesFile: "compiler:Default.isl"

[Types]
Name: "full"; Description: "Full installation"
Name: "custom"; Description: "Custom installation"; Flags: iscustom

[Components]
Name: "gui"; Description: "Main Files - GUI"; Types: full custom
;Name: "command_line"; Description: "Command line"; Types: full
; TODO: Name: "database"; Description: "Database server"; Types: full

[Tasks]
Name: desktopicon; Description: "Create a &desktop icon"; GroupDescription: "Additional icons:"; Components: gui
Name: desktopicon\common; Description: "For all users"; GroupDescription: "Additional icons:"; Components: gui; Flags: exclusive
Name: desktopicon\user; Description: "For the current user only"; GroupDescription: "Additional icons:"; Components: gui; Flags: exclusive unchecked
; TODO: Name: quicklaunchicon; Description: "Create a &Quick Launch icon"; GroupDescription: "Additional icons:"; Components: main; Flags: unchecked


[Files]
Source: ".\bin\win64\CamView.exe"; DestDir: "{app}"; Components: gui; Flags: ignoreversion
Source: ".\bin\win32\locale\CS\lc_messages\CamView.mo"; DestDir: "{app}\locale\CS\lc_messages"; Components: gui; Flags: ignoreversion
Source: ".\bin\win32\locale\CS\lc_messages\wxstd.mo"; DestDir: "{app}\locale\CS\lc_messages"; Components: gui; Flags: ignoreversion
Source: "D:\Program Files\Microsoft Visual Studio 9.0\VC\redist\amd64\Microsoft.VC90.CRT\msvcp90.dll"; DestDir: "{app}"; Components: gui
Source: "D:\Program Files\Microsoft Visual Studio 9.0\VC\redist\amd64\Microsoft.VC90.CRT\msvcr90.dll"; DestDir: "{app}"; Components: gui
;// ini file contents will be transferred to this file

[Run]

[UninstallRun]

[Dirs]

[Icons]
Name: "{group}\CamView"; Filename: "{app}\CamView.exe"
Name: "{group}\{cm:UninstallProgram,{#MyAppName}}"; Filename: "{uninstallexe}"
Name: "{userdesktop}\CamView"; Filename: "{app}\CamView.exe"; Tasks: desktopicon\user
Name: "{commondesktop}\CamView"; Filename: "{app}\CamView.exe"; Tasks: desktopicon\common


[Registry]

[INI]


[CustomMessages]


[Code]


// This procedure adds a new dialog for entering a path to isql.exe
procedure InitializeWizard;
begin
end;


// Sanity check to prevent installation on 32 bit system.
function InitializeSetup(): Boolean;
begin
 if not IsWin64() then begin
   MsgBox('Windows 64 bit distribution should not be installed on WIN 32 system', mbError, MB_OK);
   Result := false;
   end
 else begin
   Result := true;
 end;
end;


