
#include "TimeTool.h"


#if defined(_WIN32) || defined(__WIN32__) || defined(WIN32) || defined(_MSC_VER)

#include <Windows.h>

LARGE_INTEGER pFrequency = {0};


/** The standard Windows function GetTickCount() has granularity 15ms.
 * It is not good enough for fast processes. */
unsigned GetTickCount_ms(void)
{
LARGE_INTEGER CurrentTime;

  if(pFrequency.QuadPart==0)
    if(QueryPerformanceFrequency(&pFrequency)==0)
      pFrequency.QuadPart = 1;

  if(pFrequency.QuadPart <= 1) return GetTickCount();

  QueryPerformanceCounter(&CurrentTime);
  return (1000*CurrentTime.QuadPart) / pFrequency.QuadPart;
}

#else


#include <time.h>


/// Returns the number of ticks since an undefined time (usually system startup).
unsigned GetTickCount_ms(void)
{
  struct timespec ts;
  clock_gettime(CLOCK_MONOTONIC, &ts);
  return (unsigned long long)(ts.tv_nsec / 1000000) + ((unsigned long long)ts.tv_sec * 1000ull);

}

#endif
