/**@file VideoSetting.h: Function prototypes for Hardware settings. */

#ifndef _VIDEO_SET_H
#define _VIDEO_SET_H

#include <list>

#include <wx/app.h>

#include "../library/images/raster.h"
#include "../library/CameraTools.h"



/** Sets VideoSetting constants. */
class VideoSetting: public wxFrame
{
public:    
    VideoSetting(wxFrame *parent, CameraTool *NewCT, const char *TitleSuffix="");  ///< Constructor creates a frame.        
    ~VideoSetting() {Instances.remove(this);};
    
    void OnOK(wxCommandEvent & event);     ///< Processes OK button    
    void OnCancel(wxCommandEvent & event); ///< Processes cancel button. Closes the frame.        
    void OnDefault(wxCommandEvent & event);///< Processes default button.

    void OnChangeCamera(wxCommandEvent & event);    
    void OnChangeResolution(wxCommandEvent & event);
    void OnChangeRate(wxCommandEvent& event);
    void OnProperties(wxCommandEvent& event);
    void OnResolutionChanged(wxCommandEvent & event);

    void OnChangedThreshold(wxCommandEvent & event);

    void ApplyChanges(void);
    
    static std::list<VideoSetting *> Instances;
    CameraTool *CT;
            
private:
    void RefreshCameraProp(void);	   ///< Actualise camera properties inside edit boxes.
    WX_DECLARE_CONTROL_CONTAINER();    
    DECLARE_EVENT_TABLE()	// any class wishing to process wxWidgets events must use this macro
            
    wxPanel* itemPTimer;
	wxSizer *Szr_Timer;
    wxStaticText* sTextTimer;
    wxStaticText* sTextPer;
    wxTextCtrl* TxtThreshold;
    wxPanel* itemPButton;
    wxFlexGridSizer* itemFSizerBut;
    wxButton* BtnOk;
    wxButton* itemBCancel;
    wxButton* itemBDef;
    wxStaticText *Txt_Width;
    wxStaticText *Txt_Height;
    wxStaticText *Txt_Depth;
    wxStaticText *Txt_FrameRate;
    wxTextCtrl *Edt_Width;
    wxTextCtrl *Edt_Height;
    wxTextCtrl *Edt_Depth;
    wxTextCtrl *Edt_FrameRate;
    wxButton *BtnChangeCam;
    wxButton *BtnChangeRes;
    wxButton *BtnChangeRate;
    wxButton *BtnProperties;

    /** The window identifiers. */
    enum ENUMS{        
        ID_PANEL_TIMER = 1000,
        ID_TEXTCTRL_THR,
        ID_PANEL_BUTTON,
        ID_B_OK,
        ID_B_CANCEL,
        ID_B_DEFAULT,
	ID_PANEL,
        ID_TEXTCTRL_WIDTH,
        ID_TEXTCTRL_HEIGHT,
	ID_TEXTCTRL_DEPTH,
        ID_TEXTCTRL_FRAMERATE,
        ID_B_CHANGECAM,
        ID_B_CHANGERES,
        ID_B_CHANGERATE,
	ID_B_PROPERTIES
    };

};


//declare external event notification when a camera resolution is changed.
BEGIN_DECLARE_EVENT_TYPES()    
  DECLARE_EVENT_TYPE(wxEVT_CAMERARESCHANGED, -1)
  DECLARE_EVENT_TYPE(wxEVT_CAMERACHANGED, -1)
  DECLARE_EVENT_TYPE(wxEVT_NEW_FRAME_CAM1, -1)
END_DECLARE_EVENT_TYPES()


#endif //_VIDEO_SET_H
