/**@file CamView/MainFrame.h: Prototypes for a main frame. */

#ifndef _BNPMAINFRAME_H
#define _BNPMAINFRAME_H

#include <wx/spinbutt.h>
#include <wx/bitmap.h>
#include <wx/image.h>

#include "Previewer.h"
#include "PlotHistogram.h"
#include "PlotGraphFrame.h"


extern const TCHAR AboutText[];		///< Text for splash screen.
extern bool IniFileEmpty;

#define EVT_FRAME_NOTIFICATION(fn) DECLARE_EVENT_TABLE_ENTRY( wxEVT_FRAME_NOTIFICATION, -1, -1, (wxObjectEventFunction)(wxEventFunction) wxStaticCastEvent( wxPageLoadedEventFunction, & fn ), (wxObject *) NULL ),


 /** Main frame
 *  This is to be our main frame and it shows ball position graph and 
 *  widgets controlling the simulation as the application is running */
class CamViewMainFrame: public wxFrame
{
public:
   
    /** Create main frame. */
    CamViewMainFrame(const wxString& title, const wxPoint& pos, const wxSize& size);        
    ~CamViewMainFrame();
               
    void OnPaint(wxPaintEvent &WXUNUSED(event));
    void OnEraseBackground(wxEraseEvent& event); ///< When the size is changed, it is called and then it refreshs the screen and sets the layouts
    void OnAbout(wxCommandEvent& event);         ///< Display about dialog
    void OnMeasureFramerate(wxCommandEvent& WXUNUSED(event));
    void OnChartFramerate(wxCommandEvent& WXUNUSED(event));

    /** Manages the position view, video capture view  and thresholed view of the model. */    
    void OnBlackWhite(wxCommandEvent & event);
    void OnGray(wxCommandEvent & event);
    void OnColor(wxCommandEvent & event);
    void OnPaintStop(wxCommandEvent & event);
    void OnVerticalFlip(wxCommandEvent & event);
    void OnHorizontalFlip(wxCommandEvent& event);
    void OnPaintFilter(wxCommandEvent & event);
    void OnRectangle(wxCommandEvent & event);
    void Switch(VISION_STATES choice);

    void OnBlackWhite2(wxCommandEvent & event);
    void OnGray2(wxCommandEvent & event);
    void OnColor2(wxCommandEvent & event);
    void OnPaintStop2(wxCommandEvent & event);
    void OnVerticalFlip2(wxCommandEvent & event);
    void OnHorizontalFlip2(wxCommandEvent& event);
    void OnPaintFilter2(wxCommandEvent & event);
    void OnRectangle2(wxCommandEvent & event);
    void Switch2(VISION_STATES choice);
    void OnHide2(wxCommandEvent& event);

    void OnSaveAs(wxCommandEvent & event);
    void OnLoad(wxCommandEvent & event);
    void OnSaveAs2(wxCommandEvent & event);
           
    void OnVideo(wxCommandEvent& event);	///< Opens a video setup dialog
    void OnVideo2(wxCommandEvent& event);	///< Opens a video setup dialog
    void OnResolutionChange(wxCommandEvent & event); ///< Resolution change notification event.
    void OnCameraChange(wxCommandEvent & event);///< Camera change notification event.
    void OnMouseMove(wxMouseEvent &event);	///< Shows the mouse position
   
    void OnSaveConfig(wxCommandEvent& event);
    void OnReloadConfig(wxCommandEvent & event);
    void OnExitApplication(wxCommandEvent & event);
    void OnLoadConfig(void);    

    void OnHistogram(wxCommandEvent& event);	///< Opens plot frame for the graphs of signals
    void OnHistogram2(wxCommandEvent& event);	///< Opens plot frame for the graphs of signals
    void OnBallSearch(wxCommandEvent& event);	///< Starts to search for circle.
    void OnCalibrate(wxCommandEvent& event);	///< Resets the values       
    void OnSetDefault(wxCommandEvent& event);   ///< Initializes all the values to the default one.       
    void OnSize(wxSizeEvent &event);		///< When the size is changed, it is called and then it refreshs the screen and sets the layouts.
    void OnStatusbar(wxCommandEvent& event);

    void OnCamera1Frame(wxCommandEvent & event); ///< New frame notification event.
    //void OnCamera2Frame(wxCommandEvent & event); ///< New frame notification event.
    
    /** Returns pointer to  CameraPreview object    
    *  @return The pointer of CameraPreview   */
    CameraPreview* GetCameraPreview() const { return camCanvas; };

    void StartCapturing(void);		///< Starts the timer.
    void StopCapturing(void);

private:   
    WX_DECLARE_CONTROL_CONTAINER();
    DECLARE_EVENT_TABLE()	// any class wishing to process wxWidgets events must use this macro

    long AcceptedPidChange;	///< accepted PID values in a form

    wxTimer mPreviewTimer;	///< This timer periodically checks for a new frame.
    //wxTimer mTrigTimer;		///< One shot timer expected to be triggered from camera new frame event.
    wxTimer mMeasureTimer;

    wxMenu *menuFile; 
    wxMenu *menuSettings;    
    wxMenu *menuDisplay;
    wxMenu *menuHelp;
    wxMenuBar *menuBar;
    wxStatusBar *statusBar;

    wxBoxSizer* SzrChart;
    wxSizerItem *szitemChart;
    wxSizerItem *szitemChart2;
    wxPanel* iPanelRight;
    wxBoxSizer *Szr_Top;
    wxBitmap *m_bmpBkg;
    wxMenuItem *MnuMeasureFrameRate;

    wxMenuItem *CamPaint;
    wxMenuItem *CamVerticalFlip;
    wxMenuItem *CamHorizontalFlip;
    wxMenuItem *CamFilter;
    wxMenuItem *CamBW;
    wxMenuItem *CamGray;
    wxMenuItem *CamColor;
    wxMenuItem *CamRectangle;
    wxMenuItem *CamBallSearch;

    wxMenu *menuDisplay2;
    wxMenuItem *CamPaint2;
    wxMenuItem *CamVerticalFlip2;
    wxMenuItem *CamHorizontalFlip2;
    wxMenuItem *CamFilter2;
    wxMenuItem *CamBW2;
    wxMenuItem *CamGray2;
    wxMenuItem *CamColor2;
    wxMenuItem *CamRectangle2;

    CameraPreview *camCanvas;		///< Holds the camera frame1
    CameraPreview *camCanvas2;		///< Holds the camera frame1

    void OnPlotClose(wxCommandEvent & event); ///< Receive a signal that plot window was shut down    

    void OnChangedWX(wxCommandEvent & event);
    void OnChangedWY(wxCommandEvent & event);

    void OnTimer(wxTimerEvent & event);
    void OnTimerMeasure(wxTimerEvent & event);    

    int Calibrate(void);		///< Call callibrate and emit a message box when failure    
    
    wxImage  img;		      ///< Captured image        
    void ButtonMode(bool Control);    ///< Apply button visibility requirement
    volatile bool FrameTimerProcessing;
    PlotGraphFrame *FreqPlotter;

    DoublePoint Freq1, Freq2;

public:    
    unsigned LastImageTimestamp;
    unsigned LastImageTimestamp2;

    /**  Constants:
    *  IDs for the controls and the menu commands. Excluding those already defined
    *  by wxWidgets, such as wxID_NEW.   */
    enum
    {
        ID_ABOUT = 1,
        ID_CONTROL,
        ID_HARDWARE,
        ID_SAVEAS,
	ID_LOAD,
        ID_SAVEAS2,
        ID_VIDEO,
	ID_VIDEO2,
	ID_MEASURE_FRAMERATE,
        ID_CHART_FRAMERATE,
        ID_STATUSBAR,

	ID_PAINT_BW,
        ID_PAINT_GRAY,
        ID_PAINT_COLOR,
        ID_PAINT_STOP,
        ID_VERTICAL_FLIP,
        ID_HORIZONTAL_FLIP,
	ID_RECTANGLE,
        ID_FILTER_IMG,
        ID_HISTOGRAM,
        ID_BALL_SEARCH,

        ID_PAINT_BW2,
        ID_PAINT_GRAY2,
        ID_PAINT_COLOR2,
        ID_PAINT_STOP2,
        ID_VERTICAL_FLIP2,
        ID_HORIZONTAL_FLIP2,
	ID_RECTANGLE2,
        ID_FILTER_IMG2,
        ID_HISTOGRAM2,
	ID_HIDE2,
        ID_SET_DEFAULT,
        ID_START,
        ID_STOP,
        ID_SAVECONFIG,
	ID_RELOADCONFIG,
        ID_EXITAPP,
        ID_TIMER,
	//ID_TIMER_TRG,
	ID_TIMER_MEASURE,

        // GUI items        
        ID_BUTTON_RESET,        
        ID_PANEL_BUTTON,
        ID_PANEL_CONTROL,
        ID_PANEL_COOR,
        ID_PANEL_RIGHT,
        ID_PANEL_LEFT        
    };  
};



#endif //_BNPMAINFRAME_H
