; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

#define MyAppName "CamView"
#define MyAppVersion "2.6.2"
#define MyAppPublisher "F&T Soft"
#define MyAppURL "http://ftsoft.com.cz/CamView/"

[Setup]
; NOTE: The value of AppId uniquely identifies this application.
; Do not use the same AppId value in installers for other applications.
; (To generate a new GUID, click Tools | Generate GUID inside the IDE.)

AppId={{560F0B25-D54A-489d-9BFC-FA8ED0BED3B1}
AppName={#MyAppName}
AppVersion={#MyAppVersion}
;AppVerName={#MyAppName} {#MyAppVersion}
AppPublisher={#MyAppPublisher}
AppPublisherURL={#MyAppURL}
AppSupportURL={#MyAppURL}
AppUpdatesURL={#MyAppURL}
DefaultDirName={pf}\{#MyAppName}
UsePreviousAppDir=yes
DefaultGroupName={#MyAppName}
OutputDir=output_file
OutputBaseFilename=CamView_Installer-{#MyAppVersion}
Compression=lzma
SolidCompression=yes
Uninstallable=yes
AppendDefaultDirName=yes
AppMutex=CamView_Mutex,Global\CamView_Mutex
;SetupIconFile 

[Languages]
Name: "english"; MessagesFile: "compiler:Default.isl"

[Types]
Name: "full"; Description: "Full installation"
Name: "custom"; Description: "Custom installation"; Flags: iscustom

[Components]
Name: "gui"; Description: "Main Files - GUI"; Types: full custom
;Name: "command_line"; Description: "Command line"; Types: full
; TODO: Name: "database"; Description: "Database server"; Types: full

[Tasks]
Name: desktopicon; Description: "Create a &desktop icon"; GroupDescription: "Additional icons:"; Components: gui
Name: desktopicon\common; Description: "For all users"; GroupDescription: "Additional icons:"; Components: gui; Flags: exclusive
Name: desktopicon\user; Description: "For the current user only"; GroupDescription: "Additional icons:"; Components: gui; Flags: exclusive unchecked
; TODO: Name: quicklaunchicon; Description: "Create a &Quick Launch icon"; GroupDescription: "Additional icons:"; Components: main; Flags: unchecked


[Files]
Source: ".\bin\win32\CamView.exe"; DestDir: "{app}"; Components: gui; Flags: ignoreversion
Source: ".\bin\win32\locale\CS\lc_messages\CamView.mo"; DestDir: "{app}\locale\CS\lc_messages"; Components: gui; Flags: ignoreversion
Source: ".\bin\win32\locale\CS\lc_messages\wxstd.mo"; DestDir: "{app}\locale\CS\lc_messages"; Components: gui; Flags: ignoreversion
;Source: "D:\Program Files\Microsoft Visual Studio 9.0\VC\redist\x86\Microsoft.VC90.CRT\msvcp90.dll"; DestDir: "{app}"; Components: gui
;Source: "D:\Program Files\Microsoft Visual Studio 9.0\VC\redist\x86\Microsoft.VC90.CRT\msvcr90.dll"; DestDir: "{app}"; Components: gui
;// ini file contents will be transferred to this file

[InstallDelete]
Type: files; name: "{app}\msvcr71.dll";
Type: files; name: "{app}\msvcp71.dll";
Type: files; name: "{app}\msvcp90.dll";
Type: files; name: "{app}\msvcr90.dll";



[Run]

[UninstallRun]

[Dirs]

[Icons]
Name: "{group}\CamView"; Filename: "{app}\CamView.exe"
Name: "{group}\{cm:UninstallProgram,{#MyAppName}}"; Filename: "{uninstallexe}"
Name: "{userdesktop}\CamView"; Filename: "{app}\CamView.exe"; Tasks: desktopicon\user
Name: "{commondesktop}\CamView"; Filename: "{app}\CamView.exe"; Tasks: desktopicon\common


[Registry]

[INI]


[CustomMessages]


[Code]


// This procedure adds a new dialog for entering a path to isql.exe
procedure InitializeWizard;
begin
end;

