/**@file wxTools.h: Commonly used functions based on wxWindows. */
#ifndef __WX_TOOLS_H__
#define __WX_TOOLS_H__


/** Check whether editbox contains a valid double. */
double CheckDoubleTxt(wxTextCtrl* TxtVal);

/** Make one spin up step. */
void SolveSpinUp(double & Value, wxTextCtrl *Txt_Ctrl, wxScrollBar *Scr=NULL);
/** Make one spin down step. */
void SolveSpinDown(double & Value, wxTextCtrl *Txt_Ctrl, wxScrollBar *Scr=NULL);

/** Set scrollbar position according to decimal part of a given value. */
void UpdateScrollBar(double Value, wxScrollBar *Scr);

/** Update decimal part of value according to a scrollbar position. */
void UpdateValue(wxScrollBar *Scr, double *Value);

/** This is a wx fix that allows pre selection of one item. */
int wxGetSingleChoiceIndex( const wxString& message,
                            const wxString& caption,
			    int PreSelect,
                            const wxArrayString& aChoices,
                            wxWindow *parent = (wxWindow *) NULL,
                            int x = wxDefaultCoord, int y = wxDefaultCoord,
                            bool centre = true,
                            int width = wxCHOICE_WIDTH, int height = wxCHOICE_HEIGHT);


/** Calculate signum of a given value. */
inline int sign(double x) 
{
 if(x>0) return 1;
 if(x<0) return -1;
 return 0;
}


#endif //__WX_TOOLS_H__