/** @file points.cpp Implementation of basic prototypes and abstract classess for real time. */

#include "points.h"

BazeManagerDriver *BazeManagerDriver::First=NULL;  ///< List of drivers is empty.


/** This class is a container for loader modules. */
BazeManagerDriver::BazeManagerDriver(void)
{
  Next=First;
  Previous=NULL;
  First=this;
  if(Next!=NULL) Next->Previous=this;
}


/** Remove a current instance from a queue inside parents destructor. */
BazeManagerDriver::~BazeManagerDriver(void)
{
 if(First==this)
	{
	First=Next;
	if(Next!=NULL) Next->Previous=NULL;
	return;
	}
 if(Next!=NULL) Next->Previous=Previous;
 if(Previous==NULL) return; //Error
 Previous->Next=Next;
}


/** Get instance of driver from a current factory.
 *  Of course this should be overriden in a parent. */
AdDriver *BazeManagerDriver::GetDriver(int Index, const char *Name)
{
  (void)Name;(void)Index;
  return NULL;
};


/////////////////////////////////////////////

BazeCameraDriver *BazeCameraDriver::First=NULL;  ///< List of drivers is empty.


/** This class is a container for loader modules. */
BazeCameraDriver::BazeCameraDriver(void)
{
  Next=First;
  Previous=NULL;
  First=this;
  if(Next!=NULL) Next->Previous=this;
}


/** Remove a current instance from a queue inside parents destructor. */
BazeCameraDriver::~BazeCameraDriver(void)
{
 if(First==this)
	{
	First=Next;
	if(Next!=NULL) Next->Previous=NULL;
	return;
	}
 if(Next!=NULL) Next->Previous=Previous;
 if(Previous==NULL) return; //Error
 Previous->Next=Next;
}


/** Get instance of driver from a current factory.
 *  Of course this should be overriden in a parent. */
CameraDevice *BazeCameraDriver::GetDriver(int Index, const char *Name)
{
  (void)Name;(void)Index;
  return NULL;
};


#include <stdlib.h>

CameraDevice::~CameraDevice() 
{
  if(pCameraPalette) 
    {
    free(pCameraPalette);
    pCameraPalette=NULL;
    }
}