/**@file timer.h: Prototypes for real time timer. */

#ifndef __TIMER_H_INCLUDED__
#define __TIMER_H_INCLUDED__

#include <WTypes.h>
#include <MMSystem.h>


/** Class that gives access to a real time functionality. */
class RtTimer
{ 
protected: 
  MMRESULT MmR;
  int period;

public:
  bool TickIsRunning;  

  RtTimer(): TickIsRunning(false), MmR(0) {}
  void Start(int Period);
  int GetPeriodMs(void) {return(period);};
  void Stop(void);
  bool TimerRunning(void) {return MmR>0;}
  
  virtual void Tick(void) {};   ///< This procedure should be overloaded in a child

  static DWORD GetTimeInMs(void);
};


#endif  // __TIMER_H_INCLUDED__
