/****************************************************************/
/**@file OsSupp.h: 
 * Desctiption: OS dependent stuff.				*
 * Dependency: Windows (9x|2k|XP) 			        *
/****************************************************************/
#ifndef __OSSUPP_H_INCLUDED__
#define __OSSUPP_H_INCLUDED__

#include <stdexcept>
#include <wx/bitmap.h>


/** OS dependent initialisation of miscellaneous stuff. */
void InitOsDependent(void);

/** OS dependent cleanup of miscellaneous stuff. */
void DoneOsDependent(void);

/** Initialise DCOM services. This procedure filters multiple calls. */
bool InitDCOM(void);

/** Deinitialise DCOM services. */
void DoneDCOM(void);


const char *GetLang(void);


/** Load cursor from OS specific storage e.g. resources. */
bool WxLoadCursor(wxCursor *cursor, const wxString& name);

/** Load bitmap from OS specific storage e.g. resources. */
bool WxLoadBitmap(wxBitmap *bitmap, const wxString & name);

extern bool ProblemsWithBrush;
extern bool MemoryIsInitialised;


/** Exception class that notifies about problems inside camera.cpp. */
class WinAPIException: public std::exception
{
private:
  unsigned long ErrorCode;
  const char *msg;

public:
  WinAPIException(long IniCode, const char* _msg) throw() :
    ErrorCode(IniCode), msg(_msg)
  { };

  unsigned long GetCode() const throw()
  { return(ErrorCode); };

  virtual const char *what() const throw()
  { return(msg); };  

};


//---Validate float---

#ifdef _MSC_VER

#include <float.h>
#pragma warning(disable: 4800)  // conversion from int to bool

extern unsigned long NaN[2];

inline bool IsNaN(double *d) {return _isnan(*d);};  ///< Test for NaN.
inline void MakeNaN(double *d) {memcpy(d,NaN,8);};  ///< Make NaN from a given double.

#else

/** Binary representetion of float. */
typedef struct
   {
   int s:1;
   unsigned int Exponent:8;
   } FloatStruct;

inline bool IsNaN(float *f) {return (((FloatStruct *)(f))->Exponent==0xFF);};
inline void MakeNaN(float *f) {((FloatStruct *)(f))->Exponent=0xFF;};

/* Determination of IEEE NaN:  On most systems, the high word is
 * 0x7FF8 or 0xFFF8 (high bit is sign)
 * The 3 systems that don't seem to conform to this rule are:
 *    HPUX:  High word is 0x7FF4
 *    SGI:   High word is 0x7FFF */

inline bool IsNaN(double *d) {return (*((unsigned short *)(d)) & 0x7FF8) ==0x7FF8;};
inline void MakeNaN(double *d) {*((unsigned short *)(d))=0x7FF8;};

#endif


#endif //__OSSUPP_H_INCLUDED