/****************************************************************/
/**@file OsSupp.cpp: 
 * Desctiption: OS dependent stuff.				*
 * Dependency: Windows (9x|2k|XP|W7), WxWindows		        *
 ****************************************************************/

#include <windows.h>

#include <wx/wxprec.h>
#ifndef WX_PRECOMP
  #include <wx/wx.h>
#endif

#include <wx/cursor.h>
#include <wx/dcbuffer.h>
#include <wx/file.h> // loadfile
#include <wx/image.h>

#include "OsSupp.h"


/**A quiet NaN is represented by any bit pattern between X'7FF80000 00000000' and X'7FFFFFFF FFFFFFFF' or between X'FFF80000 00000000' and X'FFFFFFFF FFFFFFFF'. */
unsigned long NaN[2]={0xffffffff, 0x7fffffff};

/** Searching paths for images. */
TCHAR *Paths[]={_T(""),_T("./images/"),_T("../images/")};

bool ProblemsWithBrush = false;   ///< A brush is painted incorrectly on some platforms.
bool MemoryIsInitialised = true;  ///< Avoid re-initialising wxBufferedDC.


/** Please note that CamView needs DCOMs to be initialised. */
void InitOsDependent(void)
{
OSVERSIONINFO OS_Ver;
    
  OS_Ver.dwOSVersionInfoSize = sizeof(OS_Ver);
  if(GetVersionEx(&OS_Ver)!=0)
    if(OS_Ver.dwPlatformId<=1) 
    {
      ProblemsWithBrush = true;
      MemoryIsInitialised = false;
    }

#if defined(_WIN64) || defined(_WIN64)
  if(CreateMutex(NULL, FALSE, "Global\\CamView64_Mutex")==NULL)  // One global mutex is sufficient enough.
  {		// Create local mutex when global mutex cannot be created.
    CreateMutex(NULL, FALSE, "CamView64_Mutex");	// Mutex that prevents uninstalling when application is running.
  }
#else
  if(CreateMutex(NULL, FALSE, "Global\\CamView_Mutex")==NULL)  // One global mutex is sufficient enough.
  {		// Create local mutex when global mutex cannot be created.
    CreateMutex(NULL, FALSE, "CamView_Mutex");	// Mutex that prevents uninstalling when application is running.
  }
#endif
}


void DoneOsDependent(void)
{
 //empty
}



bool WxLoadBitmap(wxBitmap *bitmap, const wxString & name)
{
  if(bitmap==NULL) return false;

  if(bitmap->LoadFile(name, wxBITMAP_TYPE_BMP_RESOURCE))
    return true;
    
  for(int i=0;i<3;i++)  // try to find the directory with our images
    {   
    if(wxFileExists(Paths[i]+name))
      {     
      if(bitmap->LoadFile(Paths[i]+name,wxBITMAP_TYPE_CUR))        
        return true;      
      }
    } 

  return false;
}


bool WxLoadCursor(wxCursor *cursor, const wxString& name)
{
  if(cursor==NULL) return false;

    { // Try to load cursor from windows resources first
    wxCursor Cursor2(name,wxBITMAP_TYPE_CUR_RESOURCE);
    if(Cursor2.Ok())
      {      
      *cursor=Cursor2;
      return true;
      }
    }

  for(int i=0;i<3;i++)  // try to find the directory with our images
    {   
    if(wxFileExists(Paths[i]+name))
      {
      wxImage image;
      if(image.LoadFile(Paths[i]+name,wxBITMAP_TYPE_CUR))
        {
        wxCursor cursor2(image);
        *cursor = cursor2;
        return true;   
        }
      }
    }

  return false;
}


/** Setup LANGUAGE according to LCID if it is not set yet. */
const char *GetLang(void)
{
const char *Lang;
LCID WinLang;

  Lang = getenv("LANGUAGE");
  if(Lang!=NULL) return Lang;		//LANGUAGE is already set

  WinLang = GetUserDefaultLCID();
  switch(WinLang)
	{
//	case 0x0409:Lng=L"EN";break;		//English (United States);
	case 0x0419: return "RU";		//Russian
	case 0x0405: return "CS";		//Czech
	case 0x0802: return "ZH";		//Chinese
	case 0x1007:				// German (Luxembourg)
	case 0x0C07:				// German (Austria)
	case 0x0807:				// German (Switzerland)
	case 0x0407: return "DE";		//German (Standard)
	//default:swprintf(BUFF,L"%d",WinLang);
	//	Lng=BUFF;
    }
  return NULL;
}