/****************************************************************/
/**@file DCOM.cpp: 
 * Desctiption: OS dependent stuff.				*
 * Dependency: Windows (9x|2k|XP), DCOM			        *
 ****************************************************************/

/* Warning, this file might clash with XPAT from wxWidgets. */

#include <windows.h>                    

#include "OsSupp.h"

static int ComInitialized=0;	///< Internal COM initialisation flag.


/** Please note that CamView needs DCOMs to be initialised. */
bool InitDCOM(void)
{
HRESULT hr;

  if (ComInitialized>0)
    {
    ComInitialized++;
    return true;
    }

  hr = CoInitializeEx(NULL, COINIT_MULTITHREADED|COINIT_DISABLE_OLE1DDE);
  if(SUCCEEDED(hr)) 
    {
    if(hr==S_FALSE) return true;		// somebody else initialised DCOM in same mode
    ComInitialized++;
    }
  if(hr==RPC_E_CHANGED_MODE) return true;	// Somebody else initialised DCOM in different mode.
						// When ComInitialized==0 no CoUninitialize() will be called at exit.
return ComInitialized>0;
}


void DoneDCOM(void)
{
  if (ComInitialized>0)	   // unintialize COM
    {
    ComInitialized--;
    if (ComInitialized==0) 
      CoUninitialize();    
    }
}
