/**@file AboutDialog.h: Function prototypes for about dialog*/

#ifndef _ABOUTDIALOG_H
#define _ABOUTDIALOG_H

#include "wx/dcclient.h"
#include "wx/stattext.h"
#include "wx/validate.h"


/// Extend wxStaticText with a new capability of propagating mouse clicks.
class mouseStaticText: public wxStaticText
{
public:
    mouseStaticText(wxWindow *parent,
                 wxWindowID id,
                 const wxString& label,
                 const wxPoint& pos = wxDefaultPosition,
                 const wxSize& size = wxDefaultSize,
                 long style = 0,
                 const wxString& name = wxStaticTextNameStr): wxStaticText(parent, id, label, pos, size, style, name)
    {}

    void OnMouse(wxMouseEvent& event);

private:   
    DECLARE_EVENT_TABLE()
};


//declare external event notification when a camera resolution is changed.
BEGIN_DECLARE_EVENT_TYPES()    
  DECLARE_EVENT_TYPE(wxEVT_STATIC_TEXT_CLICKED, -1)
END_DECLARE_EVENT_TYPES()




/* Please note that there are two objetcs with common parent.
    Child of wxFrame does not support ShowModal();
    Child of wxDialog crashes when used as splash screen. */


/** Base class for both splash screen and about dialog. */
class AboutBase
{
public:    
    AboutBase(void): m_bmpBkg(NULL) {};
    ~AboutBase();

    void BuildLayout(wxFrame *parent, wxFrame *ThisW, const char *ImageName);
    void OnPaint(wxFrame *Fram);

    enum
    {
        ID_BTN_OK = 1,
        ID_URL_TEXT,
        ID_ALT_URL_TEXT,
	ID_TIMER
    };

protected:
    wxStaticText *m_pInfoText;     ///< Holds the text which is written down on the dialog
    wxStaticText *m_pLicText;
    mouseStaticText *m_pURL_Text;
    mouseStaticText *m_pAltURL_Text;
    wxButton *m_pOkButton;

    wxBitmap *m_bmpBkg;
};


/** About Dialog class specialised for splash screen. */
class AboutFrame: public AboutBase, public wxFrame
{
public:    
    AboutFrame(wxFrame *parent, const char *ImageName=NULL, const char *CaptionName=NULL); ///< Constructor    

    void OnPaint(wxPaintEvent & WXUNUSED(event)) {AboutBase::OnPaint(this);};
    void SetText(const wxString & text);     ///< Sets the text on the dialog
    void OnTimer(wxTimerEvent & event);      ///< Close a frame after a period given by timer expires.
    void OnMouse(wxMouseEvent& event);	     ///< Close a frame after clicking anywhere.    

protected:
    wxTimer mCloseTimer;

private:   
    DECLARE_EVENT_TABLE()	   // any class wishing to process wxWidgets events must use this macro
};


/** About Dialog class 
 * Opens new dialog and shows credits and version. */
class AboutDialog: public AboutBase, public wxDialog
{
public:    
    AboutDialog(wxFrame *parent, const char *ImageName=NULL, const char *CaptionName=NULL); ///< Constructor

    void OnPaint(wxPaintEvent & WXUNUSED(event)) {AboutBase::OnPaint((wxFrame *)this);};
    void SetText(const wxString& text);		///< Sets the text on the dialog
    void OnOk(wxCommandEvent& event);		///< OK button closes a dialog.
    void OnClickURL(wxCommandEvent& event);	///< @TODO this is not fully working yet.
    void OnClickAltURL(wxCommandEvent& event);
    //void OnMouse(wxMouseEvent& event);	     ///< Close a frame after clicking anywhere.   

    void OnClickURLtest(wxCommandEvent & event);

private:   
    DECLARE_EVENT_TABLE()	   // any class wishing to process wxWidgets events must use this macro
};


#endif