/** @file CamView/RT_EXEC.h Real time variables for camera viewer. */
#ifndef _RT_EXEC_H
#define _RT_EXEC_H

#include "../library/points.h"
#include "../library/hardware/timer.h"
#include "../library/images/raster.h"
#include "../library/CameraTools.h"


#define DEFAULT_VIDEO_WIDTH  640
#define DEFAULT_VIDEO_HEIGHT 480


/** Real time executive wrapper for CamView. */
class CamRtExec: public RtTimer
{
protected:
  unsigned TickCount;	  ///< Number of ms eaten from main period
  unsigned ControlPeriod; ///< Main time period of controller

public:
  Point *VideoX;	  ///< Ball X position from camera
  Point *VideoY;	  ///< Ball Y position from camera
  DoublePoint ReqX;       ///< Required Ball X position 
  DoublePoint ReqY;       ///< Required Ball Y position

  DoublePoint ControllerX;///< Controller X output
  DoublePoint ControllerY;///< Fake Y output, when PID is iddle

  DoublePoint DummyX;	  ///< Controller X output
  DoublePoint DummyY;	  ///< Controller Y output

  Point *Sensors;

  Point *threshold;	  ///< access to threshold property through RT point
  Point *CalibratePlate;
  
  CameraTool CT;	///< High level wrapper around a camera grabber
  CameraTool CT2;	///< High level wrapper around a camera grabber

  enum CTR_MODES
    {
    CTR_BEFORE_STARTUP=-1,
    CTR_NOT_INITIALISED=0,	///< not initialised
    CTR_CALIBRATING=1,		///< calibrating
    CTR_INITIALISED=2,		///< initialised
    CTR_RUN_1ST=3,		///< run 1st step
    CTR_RUN=4			///< normal run
    };

  CTR_MODES ControlMode;	///< mode of controller  

  CamRtExec(void);
  ~CamRtExec();

  typedef enum
    {
    SEL_CAM=	1,
    SEL_AD=	2,
    SEL_FORCE=	4,
    SEL_INIT=	8,
    SEL_CAM2=  16
    } SEL_MODES;

  void Hook2Drv(int SelectType=SEL_CAM|SEL_CAM2|SEL_INIT);
  
  void DismantleDrivers(void);  

  void SetPeriodMs(unsigned NewPeriod);
  int GetPeriodMs(void);

  int CalibrateBP(void);		///< Calibrate Ball plate's hardware.
  void InitCamera(void);

  virtual void Tick(void);
};


extern CamRtExec MRT;
extern const char APP_NAME[];


#endif //_RT_EXEC_H