/** @file PlotHistogram.h Prototypes for real time chart. */
#ifndef _PlotHistogram_H
#define _PlotHistogram_H

#include <list>
#include <wx/app.h> //app. pointer

#include "../library/Plotter.h"
#include "../library/points.h"

#include "../library/images/raster.h"
#include "../library/images/ras_comp.h"


/** Shows the graphs
 * Opens new frame and shows the graphs of the simulation signals */
class PlotHistogram: public wxFrame
{
public:
    explicit PlotHistogram(wxFrame *parent, const char *Label=NULL);
    virtual ~PlotHistogram();		  ///< Destructor    
        
    void OnBtnClear(wxCommandEvent& event);   ///< Clears the plot window       
    void OnBtnClose(wxCommandEvent& event);   ///< Hides the open plot window    
        
    void OnActivate(wxActivateEvent & event); ///< This event is fired when a fram is being activated.
    void OnClose(wxCloseEvent & event);	      ///< This event is fired when a fram is being closed.
    void OnRangeEntry(wxCommandEvent &event);        
    void OnSize(wxSizeEvent &event);	      ///< Reflect size change       
    void OnMouseMove(wxMouseEvent &event);
    void OnMnuLine(wxCommandEvent & event);
    void OnMnuFlow(wxCommandEvent & event);
    void OnMnuFLine(wxCommandEvent & event);
    void OnMnuHold(wxCommandEvent & event);
    void OnSmoothAction(wxCommandEvent& event);
    void OnHideAction(wxCommandEvent& event);
    
    void OnGrabTimer(wxTimerEvent& event);     ///< Grab one snapshot of data into a history trend
    void OnRepaintTimer(wxTimerEvent& event);
    void OnMenuOpen(wxMenuEvent& event);
    void OnEraseBackground(wxEraseEvent & event);    

    bool ColorMode;

    void AssignImage(Raster2DAbstract *newImage);
    Raster2DAbstract *Image;
    
    static std::list<PlotHistogram *> Instances;  ///< List of active instances of this window.
    static void MarkDirtyImage(const Raster2DAbstract *ImageChanged, bool NewColorMode);
    static PlotHistogram *FindHistogram(const Raster2DAbstract *pImg);
    bool QueryTimer(bool TimerStatus);

protected:
    Plotter* plotA;	  ///< Graph object at the above side    

    wxBoxSizer* Szr_Chart;

    wxMenu *menuClose;
    wxMenuItem *MnuHold;

    wxTimer mTimer;      ///< Grab data timer object
    wxTimer TmrRepaint;  ///< Repaint screen timer object

    bool FilterData;    
    bool ImageIsChanged;    
    
private:
    DECLARE_EVENT_TABLE()

    /** The window identifiers and default values */
    enum {	
        ID_BUTTON_CLEAR = 100, 
        ID_BUTTON_CLOSE,
        ID_BUTTON_HOLD,
        ID_MENU_RANGE,
        ID_MENU_SMOOTH_ACTION,
        ID_MENU_HIDE_ACTION,
        ID_MENU_CLOSE,
        ID_MENU_CLEAR,
        ID_MENU_MODE,
        ID_MENU_MODE_LINE,
        ID_MENU_MODE_FLOW,
        ID_MENU_MODE_FLINE,
        ID_PANEL,
        ID_PANEL_BUTTON,
        ID_REPAINT,
        ID_MENU_HOLD,
        TIMER_ID = 150 
    };    
};


//declare external event notification when a chart is closed.
BEGIN_DECLARE_EVENT_TYPES()    
  DECLARE_EVENT_TYPE(wxEVT_FORMCLOSED, -1)
END_DECLARE_EVENT_TYPES()



#endif
