/** @file PlotGraphFrame.h Prototypes for real time chart. */
#ifndef _PLOTGRAPHFRAME_H
#define _PLOTGRAPHFRAME_H

#include <list>
#include <wx/app.h> //app. pointer

#include "../library/Plotter.h"
#include "../library/points.h"



/**
 * Shows the graphs
 * Opens new frame and shows the graphs of the simulation signals */
class PlotGraphFrame: public wxFrame
{
public:
    PlotGraphFrame(wxFrame *parent);      
    virtual ~PlotGraphFrame();		  ///< Destructor    
        
    void OnBtnClear(wxCommandEvent& event);   ///< Clears the plot window       
    void OnBtnClose(wxCommandEvent& event);   ///< Hides the open plot window    
        
    void OnActivate(wxActivateEvent & event); ///< This event is fired when a fram is being activated.
    void OnClose(wxCloseEvent & event);	      ///< This event is fired when a fram is being closed.
    void OnRangeEntry(wxCommandEvent &event);        
    void OnSize(wxSizeEvent &event);	      ///< Reflect size change       
    void OnMouseMove(wxMouseEvent &event);
    void OnMnuLine(wxCommandEvent & event);
    void OnMnuFlow(wxCommandEvent & event);
    void OnMnuFLine(wxCommandEvent & event);
    void OnMnuHold(wxCommandEvent & event);
    void OnSmoothAction(wxCommandEvent& event);
    // void OnHideAction(wxCommandEvent& event);
    
    void OnGrabTimer(wxTimerEvent& event);     ///< Grab one snapshot of data into a history trend
    void OnRepaintTimer(wxTimerEvent& event);

    void OnMenuOpen(wxMenuEvent& event);

    void OnEraseBackground(wxEraseEvent & event);

    static std::list<PlotGraphFrame *> Instances;	///< List of active instances of this window.
    static bool FindGraphFrame(const PlotGraphFrame *pF);
    
protected:
    Plotter* plotA;	  ///< Graph object at the above side    

    wxBoxSizer* Szr_Chart;

    wxMenu *menuClose;
    wxMenuItem *MnuHold;

    wxTimer mTimer;      ///< Grab data timer object
    wxTimer TmrRepaint;  ///< Repaint screen timer object

    bool FilterData;
    
private:
    DECLARE_EVENT_TABLE()

    /** The window identifiers and default values */
    enum {	
        ID_BUTTON_CLEAR = 100, 
        ID_BUTTON_CLOSE,
        ID_BUTTON_HOLD,
        ID_MENU_RANGE,
        ID_MENU_SMOOTH_ACTION,
        ID_MENU_HIDE_ACTION,
        ID_MENU_CLOSE,
        ID_MENU_CLEAR,
        ID_MENU_MODE,
        ID_MENU_MODE_LINE,
        ID_MENU_MODE_FLOW,
        ID_MENU_MODE_FLINE,
        ID_PANEL,
        ID_PANEL_BUTTON,
	ID_REPAINT,
	ID_MENU_HOLD,
        TIMER_ID = 150 
    };    

	// Real time connectivity network points
public:
    Point *Frequency1;
    Point *Frequency2;
    DoublePoint RealTime;
};


//declare external event notification when a chart is closed.
BEGIN_DECLARE_EVENT_TYPES()    
  DECLARE_EVENT_TYPE(wxEVT_FORMCLOSED, -1)
END_DECLARE_EVENT_TYPES()



#endif

