#include <amfilter.h>
#include <renbase.h>


#if _MSC_VER < 1400	// (Visual Studio 2005)
 #include <qedit.h>
#else
 #include "../fix_c/qedit.h"
#endif


class CFrameGrabber: CBaseRenderer, virtual public ISampleGrabber
{
public:
    DECLARE_IUNKNOWN;

    CFrameGrabber(__inout_opt LPUNKNOWN pUnk, __inout HRESULT *phr);
    virtual ~CFrameGrabber();

    virtual STDMETHODIMP NonDelegatingQueryInterface(REFIID riid, __deref_out void **ppv);
    virtual HRESULT CheckMediaType(const CMediaType *pmt);
    virtual HRESULT DoRenderSample(IMediaSample *pMediaSample);

    virtual STDMETHODIMP Stop();
    virtual STDMETHODIMP Run(REFERENCE_TIME tStart);

    CBasePin *GetPin(int n);

    friend ISampleGrabber *CreateInternalFrameGrabber(IUnknown *pUnkOuter);

	// ISampleGrabber
    virtual STDMETHODIMP GetConnectedMediaType(AM_MEDIA_TYPE *pType);
    virtual STDMETHODIMP GetCurrentBuffer(long *pBufferSize, long *pBuffer);
    virtual STDMETHODIMP GetCurrentSample(IMediaSample **ppSample);

    virtual STDMETHODIMP SetBufferSamples(BOOL BufferThem);
    virtual STDMETHODIMP SetCallback(ISampleGrabberCB *pCallback, long WhichMethodToCallback);    
    virtual STDMETHODIMP SetMediaType(const AM_MEDIA_TYPE *pType);
    virtual STDMETHODIMP SetOneShot(BOOL OneShot);

    HRESULT SetMediaType(const CMediaType *pmt);
    HRESULT ReceiveConnection(IPin * pConnector, const AM_MEDIA_TYPE *pmt);

protected:
    void ClearImediaSample(void);    

    ISampleGrabberCB *m_Callback;
    CMediaType m_Type;
    IMediaSample *m_MediaSample;
    BOOL BufferSamples;
};
