/**@file CamView.h: Application for Camera Viewer. */
#ifndef _CAMVIEW_H_INCLUDED_
#define _CAMVIEW_H_INCLUDED_

#include <wx/fileconf.h> // for wxFileConfig


 /** 
 *  \mainpage CamView   
 *  \section intro_sec CamView API 
 *  This is the API for the camera viewer. 
 */

 /**
 *  The Standalone Application (Camera Viewer) 
 *  This class shows a window containing a graph, simulation controls and buttons 
 */


class CAMVIEWApp: public wxApp
{

public:
    /**
    *  '<CODE>Main()</CODE>' equivalent: the program execution "starts" here
    *  \warning override base class virtuals
    *  \warning ----------------------------
    *  \warning this one is called on application startup and is a good place for the app
    *  \warning initialization (doing it here and not in the ctor allows to have an error
    *  \warning return: if <CODE>OnInit()</CODE> returns <CODE>false</CODE>, the application terminates)
    */
    virtual bool OnInit();
    
    /** OnExit is called after destroying all application windows and controls. 
    *  @see wxApp::OnExit() */
    int OnExit();
          
    wxLocale m_locale; // locale we'll be using and language support - MUST be here !
};


DECLARE_APP(CAMVIEWApp)


#endif //_CAMVIEW_H_INCLUDED_

