#*****************************************************************************
#*****************************************************************************
#
#               Makefile for CamView
#
#               $Revision: 
#               $Date: 09/15/2006
#               $Author: fojtik $
#
#               Copyright 1994-2014.
#
#*****************************************************************************
#*****************************************************************************

ARCH := win32
OBJ_EXT := .obj

# defaults that can be overriden from command line
DEBUG := 0
LISTING := 0
JPEG := 1

# location of JPEG library
JPEGDIR := E:/libs/src/jpeg

# location of wxWidgets
WXWIDGETS := E:/libs/wxWidgets-2.8.12

# Microsoft Visual Studio .NET 2005
MSDEV8 := E:/msdev8
MSDEV  := E:/msdev

# Must be used this SDK, because dshow.h is missing in MSDEV8.
WINSDK := $(MSDEV)/Vc7/PlatformSDK
#WINSDK := $(MSDEV8)/VC/PlatformSDK

##########################
### common directories ###
##########################

DOCDIR := doc

ifeq ($(DEBUG),0)
OBJDIR := obj/$(ARCH)
BINDIR := bin/$(ARCH)
else
OBJDIR := obj/$(ARCH)d
BINDIR := bin/$(ARCH)d
endif



######################################
### compiler and linker parameters ###
######################################

# filesystem utilities
MKDIR := mkdir -p

# set path to Unix utilities at Humusoft
UNIXUTILS := G:/bat
RM    := $(UNIXUTILS)/$(RM)
MKDIR := $(UNIXUTILS)/$(MKDIR)

# compiler switches, definitions and includes
CCOUTPUT := -Fo$(OBJDIR)/
CCOPT := -nologo -Zp8 -MT -J -W3 -GF -EHsc -Oi -GR- -GS-
CCDEF := -D__WXMSW__ -DwxUSE_NO_MANIFEST=1 -D_WIN32_WINNT=0x400 -DWIN32 -D_CRT_SECURE_NO_DEPRECATE
CCINC := -I$(WXWIDGETS)/setup/$(ARCH) -I$(WXWIDGETS)/include -I$(WXWIDGETS)/lib/vc_lib/msw

# linker switches
LINKOPT := -incremental:no -machine:x86

#msvcrt.lib 
LIBS := comdlg32.lib shell32.lib advapi32.lib gdi32.lib user32.lib \
        comctl32.lib winmm.lib wsock32.lib strmiids.lib WinSpool.Lib


ifeq ($(JPEG),1)
 LINKOPT += /nodefaultlib:libc.lib
 ifeq ($(DEBUG),0)
  LIBS += $(JPEGDIR)/Release/libjpeg.lib
 else
  LIBS += $(JPEGDIR)/Debug/libjpeg.lib
 endif
endif



#############################
### set build environment ###
#############################

# debug settings
ifeq ($(DEBUG),0)	# release build
  CCDEBUG := -O2
  #LIBS += $(WXWIDGETS)/lib/$(ARCH)/libwx26.lib
  LIBS += wxbase28.lib wxmsw28_core.lib wxmsw28_adv.lib wxmsw28_media.lib wxtiff.lib wxpng.lib wxzlib.lib
  LIBS += libcpmt.lib libcmt.lib
  LINKOPT += /nodefaultlib:libc.lib /nodefaultlib:libcmt.lib
else			# debug build
  CCDEBUG := -Od -Zi -Fd$(OBJDIR)/
  LINKDEBUG := -debug
  #LIBS += $(WXWIDGETS)/lib/$(ARCH)/debug/libwx26.lib
  LIBS += wxbase28d.lib wxmsw28d_core.lib wxmsw28d_adv.lib wxmsw28d_media.lib wxtiffd.lib wxpngd.lib wxzlibd.lib
  LIBS += libcpmtd.lib libcmtd.lib
  LINKOPT += /nodefaultlib:libcd.lib
endif

ifneq ($(LISTING),0)	# generate listing
  CCDEBUG += -FAcs -Fa$(OBJDIR)/
  LINKDEBUG += -map
endif

ifeq ($(JPEG),1)
 CCINC += -I$(JPEGDIR)
endif

# platform-dependent compiler switches
ifeq ($(ARCH),win32)
CC := $(MSDEV)/Vc7/bin/cl
CCINC += -I$(WINSDK)/DirectX/Include -I$(WINSDK)/Include -I$(MSDEV)/Vc7/include
endif
ifeq ($(ARCH),win64)
CC := $(MSDEV8)/vc/bin/x86_amd64/cl
CCINC += -I$(MSDEV8)/vc/include -I$(MSDEV8)/vc/PlatformSDK/include -I$(WINSDK)/DirectX/Include -I$(WINSDK)/Include
CCOPT += -favor:AMD64
CCDEF += -D_WIN64
endif

# complete compiler command
CC += $(CCOPT) $(CCDEBUG) $(CCINC) $(CCDEF)


# platform-dependent linker switches
ifeq ($(ARCH),win32)
LINKCMD := $(MSDEV)/Vc7/bin/link
#LINKCMD := $(MSDEV8)/Vc/bin/link
LINKDEF = -def:$(notdir $(basename $@)).def
LINKOPT += -machine:ix86 -libpath:$(WINSDK)/Lib -libpath:$(MSDEV)/Vc7/lib -libpath:$(WXWIDGETS)/lib/vc_lib
endif
ifeq ($(ARCH),win64)
LINKCMD := $(MSDEV8)/vc/bin/x86_amd64/link
LINKOPT += -machine:amd64 -libpath:$(MSDEV8)/vc/lib/amd64 -libpath:$(MSDEV8)/vc/PlatformSDK/lib/amd64 -libpath:$(WINSDK)/Lib/AMD64
endif

# complete linker command
LINK = $(LINKCMD) $(LINKOPT) $(LINKDEBUG) -out:$@


#####################################
### the "all" and "clean" targets ###
#####################################

# build on Win32 only
ifeq ($(ARCH),win32)
TARGETS := $(BINDIR)/CamView.exe
endif
ifeq ($(ARCH),win64)
TARGETS := $(BINDIR)/CamView.exe
endif

all : $(TARGETS)
	

clean :
	$(RM) -r $(DOCDIR)/html
	$(RM) -r $(TARGETS) $(TARGETS).manifest $(basename $(TARGETS)).pdb $(basename $(TARGETS)).ini *.cod *.pdb *.ncb *.bak *.suo *.obj $(OBJDIR)


#components
OBJECTS:=CamView/MainFrame CamView/CamView \
         CamView/PlotHistogram CamView/Previewer \
         CamView/RT_EXEC  \
         CamView/VideoSetting \
         AboutDialog \
         CameraTools \
         points shape Plotter \
         OsSupp timer DCOM \
         PntWxTools wxTools \
         camera wxCamera \
         mtx_impl struct raster rasterc \
         filehnd ras_ftg ras_comp ras_img

ifeq ($(JPEG),1)
OBJECTS+= ras_jpg
endif

#Hardware drivers. Please do not compile both drivers together.
#CamView gets compiled without any driver, but it would not be usefull.


RESOURCES:=CamView

RC := $(MSDEV)/Vc7/bin/rc /i $(MSDEV)/Vc7/PlatformSDK/Include


#######################################
### rules for utility functions     ###
#######################################

# common dependencies
COMMONDEPS := $(OBJDIR) \
              library/*.h library/hardware/*.h \
              $(MAKEFILE_LIST)
PROJDEPS := $(OBJDIR)/CamView CamView/*.h
DRVDEPS := library/hardware/DAQ/*.h

# create destination directories
$(OBJDIR) $(BINDIR) $(OBJDIR)/CamView $(DOCDIR):
	$(MKDIR) $@

# build objects  [should not depend on $(DRVDEPS)]
$(OBJDIR)/CamView/%$(OBJ_EXT) : CamView/%.cpp $(COMMONDEPS) $(PROJDEPS) CamView/CamView.rc
	$(CC) $(CCOUTPUT)CamView/ -c $<

$(OBJDIR)/%$(OBJ_EXT) : library/%.cpp $(COMMONDEPS)
	$(CC) $(CCOUTPUT) -c $<

$(OBJDIR)/%$(OBJ_EXT) : library/hardware/%.cpp $(COMMONDEPS)
	$(CC) $(CCOUTPUT) -c $<

$(OBJDIR)/%$(OBJ_EXT) : library/images/%.cpp $(COMMONDEPS)
	$(CC) $(CCOUTPUT) -c $<

$(OBJDIR)/%$(OBJ_EXT) : library/images/%.cc $(COMMONDEPS)
	$(CC) $(CCOUTPUT) -c $<

$(OBJDIR)/%$(OBJ_EXT) : library/images/%.c $(COMMONDEPS)
	$(CC) $(CCOUTPUT) -c $<

$(OBJDIR)/%$(OBJ_EXT) : library/hardware/DAQ/%.cpp $(COMMONDEPS) $(DRVDEPS)
	$(CC) $(CCOUTPUT) -c $<

$(OBJDIR)/%$(OBJ_EXT) : library/hardware/camera/%.cpp $(COMMONDEPS) library/hardware/camera/*.h
	$(CC) $(CCOUTPUT) -c $<

$(OBJDIR)/%.res : CamView/%.rc $(OBJDIR) images/*.bmp images/*.ico images/*.cur
	$(RC) /i $(WXWIDGETS)/include /fo $(OBJDIR)/$(basename $(notdir $<)).res  $<


# link the EXE file
$(TARGETS) : $(OBJDIR)/$(addsuffix .res,$(notdir $(RESOURCES))) \
             $(addprefix $(OBJDIR)/,$(addsuffix $(OBJ_EXT), $(OBJECTS) )) \
             $(BINDIR)	
	$(LINK) $(OBJDIR)/$(addsuffix .res,$(notdir $(RESOURCES))) $(addprefix $(OBJDIR)/,$(addsuffix $(OBJ_EXT), $(OBJECTS) )) $(LIBS)


doxy : $(DOCDIR)
	$(DOXYGEN) $<
